require "dl/import"
module DXLIB2
  extend DL::Importer
  dlload "./dxlib_x32.dll"
  extern "long DX_OpenPort( char *, long )"
  extern "int DX_Active( long )"
  extern "int DX_Ping( long, unsigned char, int, unsigned short * )"
  extern "int DX_ReadWordData( long, unsigned char, unsigned short, unsigned short *, int, unsigned short * )"
  extern "int DX_WriteWordData( long, unsigned char, unsigned short, unsigned short, int, unsigned short * )"
  extern "int DX_ReadByteData( long, unsigned char, unsigned short, unsigned char *, int, unsigned short * )"
  extern "int DX_WriteByteData( long, unsigned char, unsigned short, unsigned char, int, unsigned short * )"
  extern "int DX_ClosePort( long )"
end
comport = "\\\\.\\COM3"
br = 1000000
uid = 1
TORQUE_ENABLE_ADDR = 24
GOAL_POS_ADDR = 30
TORQUE_LIMIT_ADDR = 34
PRESENT_POS_ADDR = 36
MAX_POSITION = 620
MIN_POSITION = 400
SLEEP_TIME = 0.05
LOOP_COUNT = 20
OK = 1
NG = 0
terr = ' ' * 2
rbuff = ' ' * 2
pos = 0
devid = DXLIB2.DX_OpenPort( comport, br )
if ( devid != 0  ) then
  print "Waiting...\n"
  sleep 1
  if ( DXLIB2.DX_Ping( devid, uid, terr ) == OK ) then
    if ( DXLIB2.DX_WriteWordData( devid, uid, TORQUE_LIMIT_ADDR, 300, terr ) != OK ) then
      printf( "torque limit write error(%x)\n", terr.unpack('S')[0] )
    end
    i = 1
    while( i < 10 )
      if ( pos == MAX_POSITION ) then
        pos = MIN_POSITION
      else
        pos = MAX_POSITION
      end
      if ( DXLIB2.DX_WriteWordData( devid, uid, GOAL_POS_ADDR, pos, terr ) == OK ) then
        j = 0
        while( j < LOOP_COUNT )
          if ( DXLIB2.DX_ReadWordData( devid, uid, PRESENT_POS_ADDR, rbuff, terr ) == OK ) then
            printf("POS:%d\r", rbuff.unpack('S')[0])
          else
            printf("read error(%x)\n", terr.unpack('S')[0])
          end
          sleep SLEEP_TIME
          j += 1
        end
      else
        printf( "write error(%x)\n", terr.unpack('S')[0] )
      end
      i += 1
    end
    DXLIB2.DX_WriteByteData( devid, uid, TORQUE_ENABLE_ADDR, 0, terr )
  else
    p "Motor dead"
  end
  if ( DXLIB2.DX_ClosePort( devid ) != OK ) then
    print "CLOSE ERROR\n"
  end
else
  print "Port Open Failed"
end
print("normal end")
