from ctypes import *
import sys
# load library
dxlib2  = windll.LoadLibrary("dxlib_x32.dll")
dxopen  = dxlib2.DX_OpenPort
dxclose = dxlib2.DX_ClosePort
dxping  = dxlib2.DX_Ping
# set types for return and parameter of API
dxopen.argtypes  = [c_char_p, c_long]
dxopen.restype   = c_void_p
dxclose.argtypes = [c_void_p]
dxping.argtypes  = [c_void_p, c_ubyte, c_int, c_void_p]
# initialize
terr = c_ushort()
comport  = "\\.\COM3"
baudrate = 1000000
procsw   = 0
OK = 1
NG = 0
cr = "\n"
lf = "\r"
# call API
devid = dxopen( comport, baudrate )
for idx in range(254):
  result = dxping( devid, idx, byref(terr) )
  if result == OK:
    sys.stdout.write( "\n%d alive" % idx )
    procsw = 0
  else:
    if procsw == 0:
      sys.stdout.write( cr )
    else:
      sys.stdout.write( lf )
    sys.stdout.write( "%d dead(%x)" % (idx,terr.value) )
    procsw = 1
  sys.stdout.flush()
dxclose( devid )
