/*----------------------------------------------------------*
    dxlib.h
    Dynamixelプロトコル用API V3.1
                                       Last Edit '15 11/17
   Copyright (c) 2005, 2015 BestTechnology CO.,LTD.
 *----------------------------------------------------------*/

#ifndef _DXLIB_H_INCLUDE
#define _DXLIB_H_INCLUDE

#ifdef __cplusplus
extern "C" {
#endif
#ifdef _WIN32
#include <windows.h>
#else
#include <pthread.h>
#endif

#ifndef _MSC_VER
#include <stdbool.h>
#endif
#include <stdint.h>

#define BROADCASTING_ID     (0xfe)

//#define DXMAXLENGTH         (143)
#define DXMAXLENGTH         (250)

#ifndef _WIN32
  typedef int                             HANDLE;
  typedef pthread_mutex_t                 CRITICAL_SECTION;

  #define EnterCriticalSection(mtx)       pthread_mutex_lock(mtx)
  #define LeaveCriticalSection(mtx)       pthread_mutex_unlock(mtx)
  #define DeleteCriticalSection(mtx)      pthread_mutex_destroy(mtx)
  #define InitializeCriticalSection(mtx)  pthread_mutex_init(mtx,NULL)
  #define SetEvent(evt)                   pthread_cond_signal(evt)
  #define INVALID_int_VALUE               -1
  #define INVALID_HANDLE_VALUE            -1
#endif

// デバイスID
#ifdef _WIN32
  #ifdef _WIN64
  typedef uint64_t TDeviceID;
  #else
  typedef uint32_t TDeviceID;
  #endif
#else
  #ifdef __x86_64__
  typedef uint64_t TDeviceID;
  #else
  typedef uint32_t TDeviceID;
  #endif
#endif

// インストラクション
typedef enum {INST_PING = 1, INST_READ = 2, INST_WRITE = 3, INST_REG_WRITE = 4, INST_ACTION = 5, INST_RESET = 6, INST_SYNC_WRITE = 0x83, INST_SYNG_REG_WRITE = 0x85} TInstruction;

// エラーフラグ
typedef uint16_t TErrorCode;
#define ERR_INVALID_DEVID   (1 << 15)
#define ERR_INVALID_ID      (1 << 14)
#define ERR_DIFF_ID         (1 << 13)
#define ERR_ILLEGAL_SIZE    (1 << 12)
#define ERR_INVALID_PARAM   (1 << 11)
#define ERR_COMM            (1 << 10)
#define ERR_CHECKSUM        (1 << 9)
#define ERR_TIMEOUT         (1 << 8)
#define ERR_DX_INST         (1 << 6)
#define ERR_DX_OVERLOAD     (1 << 5)
#define ERR_DX_CHECKSUM     (1 << 4)
#define ERR_DX_RANGE        (1 << 3)
#define ERR_DX_OVERHEAT     (1 << 2)
#define ERR_DX_ANGLE        (1 << 1)
#define ERR_DX_OVERVOLTAGE  (1 << 0)
#define ERR_NON             (0)

// アラームステータス
#ifdef _MSC_VER
__pragma(pack(push, 1))
typedef struct {
  uint8_t     id;
  TErrorCode  Status;
} TDxAlarmStatus;
__pragma(pack(pop))
#elif defined(__GNUC__)
typedef struct {
  uint8_t     id;
  TErrorCode  Status;
} __attribute__ ((gcc_struct, __packed__)) TDxAlarmStatus;
#endif


#ifdef _WIN32
  #ifdef __cplusplus
    #ifdef __MAKE_LIB__
      #define DXAPIDLL extern "C" __declspec(dllexport) WINAPI
    #else
      #define DXAPIDLL extern "C" __declspec(dllimport) WINAPI
    #endif
  #else
    #ifdef __MAKE_LIB__
      #define DXAPIDLL __declspec(dllexport) WINAPI
    #else
      #define DXAPIDLL __declspec(dllimport) WINAPI
    #endif
  #endif
#else
  #define DXAPIDLL
  #define WINAPI
#endif

#ifndef _DYNAMICLOAD
// 静的なDLL呼び出し時は以下のプロトタイプ宣言を使用
DXAPIDLL TDeviceID DX_OpenPort (char *name, uint32_t baud);
DXAPIDLL bool DX_ClosePort (TDeviceID dvid);
DXAPIDLL bool DX_SetBaudrate (TDeviceID dvid, uint32_t baud);
DXAPIDLL bool DX_Active (TDeviceID dvid);
DXAPIDLL void DX_SetTimeOutOffset (TDeviceID dvid, uint32_t t);
DXAPIDLL double GetQueryPerformanceCounter (void);
DXAPIDLL bool DX_TxPacket (TDeviceID dvid, uint8_t id, TInstruction inst, uint8_t *param, uint32_t len, TErrorCode *err);
DXAPIDLL bool DX_RxPacket (TDeviceID dvid, uint8_t *rdata, uint32_t rdatasize, uint32_t *rlen, uint32_t timeout, TErrorCode *err);
DXAPIDLL bool DX_ReadByteData(TDeviceID dvid, uint8_t id, uint16_t adr, uint8_t *rdata, TErrorCode *err);
DXAPIDLL bool DX_WriteByteData(TDeviceID dvid, uint8_t id, uint16_t adr, uint8_t dat, TErrorCode *err);
DXAPIDLL bool DX_ReadWordData(TDeviceID dvid, uint8_t id, uint16_t adr, uint16_t *rdata, TErrorCode *err);
DXAPIDLL bool DX_WriteWordData(TDeviceID dvid, uint8_t id, uint16_t adr, uint16_t dat, TErrorCode *err);
DXAPIDLL bool DX_ReadBlockData (TDeviceID dvid, uint8_t id, uint16_t adr, uint8_t *rdata, uint32_t len, TErrorCode *err);
DXAPIDLL bool DX_WriteBlockData(TDeviceID dvid, uint8_t id, uint16_t adr, uint8_t *dat, uint32_t len, TErrorCode *err);
DXAPIDLL bool DX_Ping(TDeviceID dvid, uint8_t id, TErrorCode *err);
DXAPIDLL bool DX_Ping2(TDeviceID dvid, uint32_t *num, TDxAlarmStatus *AlarmStatus, TErrorCode *err);
DXAPIDLL bool DX_ReadSyncData (TDeviceID dvid, uint8_t *dat, uint32_t size, uint8_t *retdat, TErrorCode *err);
DXAPIDLL bool DX_WriteSyncData (TDeviceID dvid, uint8_t *dat, uint32_t size, TErrorCode *err);
DXAPIDLL bool DX_Reset (TDeviceID dvid, uint8_t id, TErrorCode *err);

#else
// 動的なDLL呼び出し時は以下の型宣言を使用
typedef TDeviceID (WINAPI *_DX_OpenPort)(char *name, uint32_t baud);
typedef bool (WINAPI *_DX_ClosePort)(TDeviceID dvid);
typedef bool (WINAPI *_DX_SetBaudrate) (TDeviceID dvid, uint32_t baud);
typedef bool (WINAPI *_DX_Active)(TDeviceID dvid);
typedef void (WINAPI *_DX_SetTimeOutOffset)(TDeviceID dvid, uint32_t offsettime);
typedef bool (WINAPI *_DX_TxPacket) (TDeviceID dvid, uint8_t id, TInstruction inst, uint8_t *param, uint32_t len, TErrorCode *err);
typedef bool (WINAPI *_DX_RxPacket) (TDeviceID dvid, uint8_t *rdata, uint32_t rdatasize, uint32_t *rlen, uint32_t timeout, TErrorCode *err);
typedef bool (WINAPI *_DX_ReadByteData)(TDeviceID dvid, uint8_t id, uint16_t adr, uint8_t *rdata, TErrorCode *err);
typedef bool (WINAPI *_DX_WriteByteData)(TDeviceID dvid, uint8_t id, uint16_t adr, uint8_t dat, TErrorCode *err);
typedef bool (WINAPI *_DX_ReadWordData)(TDeviceID dvid, uint8_t id, uint16_t adr, uint16_t *rdata, TErrorCode *err);
typedef bool (WINAPI *_DX_WriteWordData)(TDeviceID dvid, uint8_t id, uint16_t adr, uint16_t dat, TErrorCode *err);
typedef bool (WINAPI *_DX_ReadBlockData)(TDeviceID dvid, uint8_t id, uint16_t adr, uint8_t *rdata, uint8_t len, TErrorCode *err);
typedef bool (WINAPI *_DX_WriteBlockData)(TDeviceID dvid, uint8_t id, uint16_t adr, uint8_t *dat, uint32_t len, TErrorCode *err);
typedef bool (WINAPI *_DX_Ping)(TDeviceID dvid, uint8_t id, TErrorCode *err);
typedef bool (WINAPI *_DX_Ping2)(TDeviceID dvid, uint32_t *num, TDxAlarmStatus *AlarmStatus, TErrorCode *err);
typedef bool (WINAPI *_DX_ReadSyncData) (TDeviceID dvid, uint8_t *dat, uint32_t size, uint8_t *retdat, TErrorCode *err);
typedef bool (WINAPI *_DX_WriteSyncData) (TDeviceID dvid, uint8_t *dat, uint32_t size, TErrorCode *err);
typedef bool (WINAPI *_DX_Reset) (TDeviceID dvid, uint8_t id, TErrorCode *err);

_DX_OpenPort          DX_OpenPort = NULL;
_DX_ClosePort         DX_ClosePort = NULL;
_DX_SetBaudrate       DX_SetBaudrate = NULL;
_DX_Active            DX_Active = NULL;
_DX_SetTimeOutOffset  DX_SetTimeOutOffset = NULL;
_DX_TxPacket          DX_TxPacket = NULL;
_DX_RxPacket          DX_RxPacket = NULL;
_DX_ReadByteData      DX_ReadByteData = NULL;
_DX_WriteByteData     DX_WriteByteData = NULL;
_DX_ReadWordData      DX_ReadWordData = NULL;
_DX_WriteWordData     DX_WriteWordData = NULL;
_DX_ReadBlockData     DX_ReadBlockData = NULL;
_DX_WriteBlockData    DX_WriteBlockData = NULL;
_DX_ReadSyncData      DX_ReadSyncData = NULL;
_DX_WriteSyncData     DX_WriteSyncData = NULL;
_DX_Ping              DX_Ping = NULL;
_DX_Ping2             DX_Ping2 = NULL;
_DX_Reset             DX_Reset = NULL;

static HMODULE hModule = NULL;

#ifdef _WIN32
#ifdef _WIN64
#define DLLNAME   "dxlib_x64.dll"
#else
#define DLLNAME   "dxlib_x32.dll"
#endif
#else
#ifdef __x86_64__
#define DLLNAME   "dxlib_x64.dll"
#else
#define DLLNAME   "dxlib_x32.dll"
#endif
#endif

// DLLのロード
bool LoadDLL (void) {
  hModule = LoadLibrary (DLLNAME);
  if (hModule == NULL) {
    return false;
  }

  DX_OpenPort         = (_DX_OpenPort)GetProcAddress (hModule, "DX_OpenPort");
  DX_ClosePort        = (_DX_ClosePort)GetProcAddress (hModule, "DX_ClosePort");
  DX_SetBaudrate      = (_DX_SetBaudrate)GetProcAddress (hModule, "DX_SetBaudrate");
  DX_Active           = (_DX_Active)GetProcAddress (hModule, "DX_Active");
  DX_SetTimeOutOffset = (_DX_SetTimeOutOffset)GetProcAddress (hModule, "DX_SetTimeOutOffset");
  DX_TxPacket         = (_DX_TxPacket)GetProcAddress (hModule, "DX_TxPacket");
  DX_RxPacket         = (_DX_RxPacket)GetProcAddress (hModule, "DX_RxPacket");
  DX_ReadByteData     = (_DX_ReadByteData)GetProcAddress (hModule, "DX_ReadByteData");
  DX_WriteByteData    = (_DX_WriteByteData)GetProcAddress (hModule, "DX_WriteByteData");
  DX_ReadWordData     = (_DX_ReadWordData)GetProcAddress (hModule, "DX_ReadWordData");
  DX_WriteWordData    = (_DX_WriteWordData)GetProcAddress (hModule, "DX_WriteWordData");
  DX_ReadBlockData    = (_DX_ReadBlockData)GetProcAddress (hModule, "DX_ReadBlockData");
  DX_WriteBlockData   = (_DX_WriteBlockData)GetProcAddress (hModule, "DX_WriteBlockData");
  DX_ReadSyncData     = (_DX_ReadSyncData)GetProcAddress (hModule, "DX_ReadSyncData");
  DX_WriteSyncData    = (_DX_WriteSyncData)GetProcAddress (hModule, "DX_WriteSyncData");
  DX_Ping             = (_DX_Ping)GetProcAddress (hModule, "DX_Ping");
  DX_Ping2            = (_DX_Ping2)GetProcAddress (hModule, "DX_Ping2");
  DX_Reset            = (_DX_Reset)GetProcAddress (hModule, "DX_Reset");

  return
    (DX_OpenPort         != NULL) &&
    (DX_ClosePort        != NULL) &&
    (DX_SetBaudrate      != NULL) &&
    (DX_Active           != NULL) &&
    (DX_SetTimeOutOffset != NULL) &&
    (DX_TxPacket         != NULL) &&
    (DX_RxPacket         != NULL) &&
    (DX_ReadByteData     != NULL) &&
    (DX_WriteByteData    != NULL) &&
    (DX_ReadWordData     != NULL) &&
    (DX_WriteWordData    != NULL) &&
    (DX_ReadBlockData    != NULL) &&
    (DX_WriteBlockData   != NULL) &&
    (DX_ReadSyncData     != NULL) &&
    (DX_WriteSyncData    != NULL) &&
    (DX_Ping             != NULL) &&
    (DX_Ping2            != NULL) &&
    (DX_Reset            != NULL);
}

// DLLのアンロード
void UnloadDLL (void) {
  if (hModule != NULL) {
    FreeLibrary (hModule);
    DX_OpenPort         = NULL;
    DX_ClosePort        = NULL;
    DX_SetBaudrate      = NULL;
    DX_Active           = NULL;
    DX_SetTimeOutOffset = NULL;
    DX_TxPacket         = NULL;
    DX_RxPacket         = NULL;
    DX_ReadByteData     = NULL;
    DX_WriteByteData    = NULL;
    DX_ReadWordData     = NULL;
    DX_WriteWordData    = NULL;
    DX_ReadBlockData    = NULL;
    DX_WriteBlockData   = NULL;
    DX_ReadSyncData     = NULL;
    DX_WriteSyncData    = NULL;
    DX_Ping             = NULL;
    DX_Ping2            = NULL;
    DX_Reset            = NULL;
  }
}

#endif

#ifdef __cplusplus
}
#endif

#endif //_DXLIB_H_INCLUDE
