from ctypes import *
import time
import sys
dxlib2      = windll.LoadLibrary("dxlib_x32.dll")
dxopen      = dxlib2.DX_OpenPort
dxclose     = dxlib2.DX_ClosePort
dxping      = dxlib2.DX_Ping
dxwriteword = dxlib2.DX_WriteWordData
dxreadword  = dxlib2.DX_ReadWordData
dxwritebyte = dxlib2.DX_WriteByteData
# set API return & parameter type
dxopen.argtypes = [c_char_p, c_long]
dxopen.restype = c_void_p
dxclose.argtypes = [c_void_p]
dxping.argtypes = [c_void_p, c_ubyte, c_int, c_void_p]
dxwriteword.argtypes = [c_void_p, c_ubyte, c_ushort, c_ushort, c_int, c_void_p]
dxreadword.argtypes  = [c_void_p, c_ubyte, c_ushort, c_void_p, c_int, c_void_p]
dxwritebyte.argtypes = [c_void_p, c_ubyte, c_ushort, c_void_p, c_int, c_void_p]
TORQUE_ENABLE_ADDR = 24
GOAL_POS_ADDR = 30
TORQUE_LIMIT_ADDR = 34
PRESENT_POS_ADDR = 36
MAX_POSITION = 620
MIN_POSITION = 400
OK = 1
NG = 0
terr = c_ushort()
dat  = c_ushort()
pos  = MAX_POSITION
# call API
devid = dxopen( "\\.\COM3", 1000000 )
if devid != 0:
  sys.stdout.write( "Waiting..." )
  sys.stdout.flush()
  time.sleep( 1.0 )
  print()
  if dxwriteword( devid, 1, TORQUE_LIMIT_ADDR, 300, byref(terr) ) != OK:
    print( "torque limit write error(%x)" % terr.value )
  for i in range(10):
    if pos == MAX_POSITION:
      pos = MIN_POSITION
    else:
      pos = MAX_POSITION
    if dxwriteword( devid, 1, GOAL_POS_ADDR, pos, byref(terr) ) == OK:
      for j in range(10):
        if dxreadword( devid, 1, PRESENT_POS_ADDR, byref(dat), byref(terr) ) == OK:
          sys.stdout.write( "POS:%04d\r" % dat.value )
        else:
          sys.stdout.write( "\nread error(%x)\n" % terr.value )
        sys.stdout.flush()
        time.sleep( 0.1 )
    else:
      sys.stdout.write( "\nwrite error(%x)\n" % terr.value )
  dxwritebyte( devid, 1, TORQUE_ENABLE_ADDR, 0, byref(terr) )
dxclose( devid )
