/*
  WORD幅のアイテムへのアクセス
*/
#include <stdio.h>
#include <unistd.h>
#include "dxlib.h"
#include "dxmemmap.h"

// マクロ定義
#define COMPORT   "/dev/ttyUSB0"  // ポート番号
#define BAUDRATE  (2000000)       // ボーレート[bps]
#define TARGETID  (1)             // 対象となるID

void main (void) {
  int         i, f = 5;
  uint16_t    pos;
  TDeviceID   dev;
  TErrorCode  err;

  if ((dev = DX_OpenPort (COMPORT, BAUDRATE))) {
    printf("Open success\n");

    if (DX_Ping (dev, TARGETID, &err)) {
      // 現在の位置を読み出し
      if (DX_ReadWordData (dev, TARGETID, ADDRESS_PRESENT_POSITION, &pos, &err)) {
        printf ("Now position = %4d\n", pos);
        // 何かキーを押すとループを抜ける
        for (i = 0; i < 2000; i++) {
          pos += f;
          if (pos >= 4096) { pos = 4095; f = -5; }
          else if (pos <= 0) { pos = 0; f = 5; }
          // 目標位置を書き込み
          if (DX_WriteWordData (dev, TARGETID, ADDRESS_GOAL_POSITION, pos, &err))
            printf ("Sent position = %4d\r", pos);
          else
            printf ("Write error [$%04X]\n", err);
          // 5ミリ秒待ち
          usleep (5000);
        }
        printf ("\n");
      } else
        printf ("Read error [$%04X]\n", err);
    }

    DX_ClosePort (dev);
  } else {
    printf ("Open error\n");
  }
  printf ("Fin\n");
  getchar();
}
