/*
  I/F̓gp

  ^[Qbg:AX-12
*/

#include <stdio.h>
#include <process.h>
#include <conio.h>
#include "dxlib.h"
#include "dxmemmap.h"

#define COMPORT1    "\\\\.\\COM10"
#define COMPORT2    "\\\\.\\COM12"
#define BAUDRATE    (1000000)
#define OFFSETTIME  (20)
#define TARGETID1   (1)
#define TARGETID2   (1)

BOOL terminate = FALSE;

BOOL DxGetPosition (TDeviceID dvid, UCHAR id, USHORT *pos, TErrorCode *err) {
  return DX_ReadWordData (dvid, id, ADDRESS_PRESENT_POSITION, (USHORT *)pos, err);
}

BOOL DxSetPosition (TDeviceID dvid, UCHAR id, USHORT pos, TErrorCode *err) {
  return DX_WriteWordData (dvid, id, ADDRESS_GOAL_POSITION, (USHORT)pos, err);
}

unsigned __stdcall thread (void *dum) {
  TDeviceID   dev;
  TErrorCode  err;
  USHORT        pos = 100, ppos;
  int           f = 1;

  if ((dev = DX_OpenPort (COMPORT2, BAUDRATE))) {
    printf ("Open %s success\n", COMPORT2);
  } else {
    printf ("Open %s error\n", COMPORT2);
  }

  DX_SetTimeOutOffset (dev, OFFSETTIME);

  while (!terminate) {
    if (DX_Active (dev)) {
      pos += f;
      if (pos >= 1023) { pos = 1023; f = -1; }
      else if (pos <= 0) { pos = 0; f = 1; }

      if (!DxSetPosition (dev, TARGETID2, pos, &err))
        printf ("\nSetPos (%s, %d) error [%04X]", COMPORT2, TARGETID2, err);
      if (DxGetPosition (dev, TARGETID2, &ppos, &err))
        printf ("\nGetPos (%s, %d) = %d", COMPORT2, TARGETID2, ppos);
      else
        printf ("\nGetPos (%s, %d) error [%04X]", COMPORT2, TARGETID2, err);
    }
    Sleep (10);
  }

  if (dev) DX_ClosePort (dev);

  _endthreadex (0);
  return 0;
}

void main (void) {
  TDeviceID    dev;
  TErrorCode  err;
  HANDLE        mythread;

  // COMPORT2̏ʃXbh
  if ((mythread = (HANDLE)_beginthreadex (NULL, 0, &thread, 0, 0, NULL)) == INVALID_HANDLE_VALUE) {
    printf ("beginthread error\n");
  }

  // COMPORT1̏main
  if ((dev = DX_OpenPort (COMPORT1, BAUDRATE))) {
    printf ("Open %s success\n", COMPORT1);
  } else {
    printf ("Open %s error\n", COMPORT1);
  }

  Sleep (1000);

  USHORT  pos = 500, ppos;
  int     f = 1;
  while (!kbhit ()) {
    if (DX_Active (dev)) {
      pos += f;
      if (pos >= 1023) { pos = 1023; f = -1; }
      else if (pos <= 0) { pos = 0; f = 1; }

      if (!DxSetPosition (dev, TARGETID1, pos, &err))
        printf ("\nSetPos (%s, %d) error [%04X]", COMPORT1, TARGETID1, err);
      if (DxGetPosition (dev, TARGETID1, &ppos, &err))
        printf ("\nGetPos (%s, %d) = %d", COMPORT1, TARGETID1, ppos);
      else
        printf ("\nGetPos (%s, %d) error [%04X]", COMPORT1, TARGETID1, err);
    }
    Sleep(10);
  }

  if (dev) DX_ClosePort (dev);

  if (mythread != INVALID_HANDLE_VALUE) {
    terminate = TRUE;
    WaitForSingleObject (mythread, 1000);
  }

  printf ("Fin\n");
  getchar();
}
