unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, DXLIB, ExtCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    ScrollBar1: TScrollBar;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Timer1: TTimer;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Button1Click(Sender: TObject);
    procedure ScrollBar1Change(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    { Private 錾 }
    devid:  TDeviceID;
    function AllActive:boolean;
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// DLL̃[hƃ|[gI[v̏Ԏ擾
function TForm1.AllActive:boolean;
begin
  result := False;
  if DXLIB_Active then
    if (devid <> nil) then result := DX_Active (devid);
end;

// tH[쐬
procedure TForm1.FormCreate(Sender: TObject);
begin
  devid := 0;
  DXLIB_Load;    // DLL̃_Ci~bN[h
end;

// tH[
procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if AllActive then DX_ClosePort(devid);  // DLL[hĂ|[gJĂ
  Timer1.Enabled := False;
  DXLIB_Unload;  // DLL̃A[h
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  portname: ansistring;
begin
  // |[gI[v
  if (devid = nil) and DXLIB_Active then
  begin
    portname := '\\.\COM3';
    devid := DX_OpenPort(PChar(portname), 1000000);
    if AllActive then
    begin
      Button1.Caption := 'close';
      Timer1.Enabled := True;
    end else
    begin
      Timer1.Enabled := False;
    end;
  end else
  // |[gN[Y
  begin
    if AllActive then DX_ClosePort(devid);
    Button1.Caption := 'open';
    devid := 0;
    Timer1.Enabled := False;
  end;
end;

// XN[o[̃XChňʒuw
procedure TForm1.ScrollBar1Change(Sender: TObject);
var
  err: TErrorCode;
begin
  DX_WriteWordData(devid, 1, 30, ScrollBar1.Position, err);
  Label1.Caption := 'write errstat:$' + IntToHex(err, 4);
end;

// ^C}Ō݈ʒu擾
procedure TForm1.Timer1Timer(Sender: TObject);
var
  err: TErrorCode;
  pos:WORD;
begin
  if AllActive then
  begin
    if DX_ReadWordData(devid, 1, 36, pos, err) then
      Label3.Caption := 'present position:' + IntToStr(pos)
    else
      Label3.Caption := 'present position:?';
    Label2.Caption := 'read errstat:$' + IntToHex(err, 4);
  end else
  begin
    Timer1.Enabled := False;
    Label3.Caption := 'present position:-';
  end;
end;

end.
