unit DXLIB;

interface

uses
  Windows, SysUtils;

type
  TDeviceID   = Pointer;
  TErrorCode  = WORD;
  TInstruction  = BYTE;

  // A[Xe[^X
  TAlarmStatus = packed Record
    id      :uint8;
    Status  :TErrorCode;
  end;
  PAlarmStatus = ^TAlarmStatus;

  TDX_OpenPort = function (pcom:pchar; br:uint32):TDeviceID; stdcall;
  TDX_ClosePort = function (dvid:TDeviceID):BOOL; stdcall;
  TDX_SetBaudrate = function (dvid:TDeviceID; br:uint32):BOOL; stdcall;
  TDX_SetTimeOutOffset = procedure (dvid:TDeviceID; offsettime:uint32); stdcall;

  TDX_Active = function (dvid:TDeviceID):BOOL; stdcall;

  TDX_TxPacket = function (dvid:TDeviceID; id:uint8; inst:TInstruction; var param:uint8; len:uint32; var err:TErrorCode):BOOL; stdcall;
  TDX_RxPacket = function (dvid:TDeviceID; var rdata:uint8; rdatasize:uint32; var rlen:uint32; timeout:uint32; var err:TErrorCode):BOOL; stdcall;

  TDX_ReadByteData = function (dvid:TDeviceID; id:uint8; adr:uint16; var result:uint8; var errcode:TErrorCode):BOOL; stdcall;
  TDX_WriteByteData = function (dvid:TDeviceID; id:uint8; adr:uint16; dat:uint8; var errcode:TErrorCode):BOOL; stdcall;

  TDX_ReadWordData = function (dvid:TDeviceID; id:uint8; adr:uint16; var result:uint16; var errcode:TErrorCode):BOOL; stdcall;
  TDX_WriteWordData = function (dvid:TDeviceID; id:uint8; adr:uint16; dat:uint16; var errcode:TErrorCode):BOOL; stdcall;

  TDX_ReadBlockData = function (dvid:TDeviceID; id:uint8; adr:uint16; var result:uint8; len:uint32; var errcode:TErrorCode):BOOL; stdcall;
  TDX_WriteBlockData = function (dvid:TDeviceID; id:uint8; adr:uint16; var dat:uint8; len:uint32; var errcode:TErrorCode):BOOL; stdcall;

  TDX_Ping = function (dvid:TDeviceID; id:uint8; var errcode:TErrorCode):BOOL; stdcall;
  TDX_Ping2 = function (dvid:TDeviceID; var num:uint32; AlarmStatus:PAlarmStatus; var errcode:TErrorCode):BOOL; stdcall;

  TDX_ReadSyncData = function (dvid:TDeviceID; var dat:uint8; size:uint32; var retdat:uint8; var errcode:TErrorCode):BOOL; stdcall;
  TDX_WriteSyncData = function (dvid:TDeviceID; var dat:uint8; size:uint32; var errcode:TErrorCode):BOOL; stdcall;

  TDX_Reset = function (dvid:TDeviceID; id:uint8; var errcode:TErrorCode):BOOL; stdcall;

  function DXLIB_Load:boolean;
  procedure DXLIB_Unload;
  function DXLIB_Active:boolean;

  function conv_s11(v:pword):integer;
  function conv_sig(v:pword):integer;
  function conv_wd(v:pword):integer;

const
  INST_PING           = $01;
  INST_READ           = $02;
  INST_WRITE          = $03;
  INST_REG_WRITE      = $04;
  INST_ACTION         = $05;
  INST_RESET          = $06;
  INST_SYNC_WRITE     = $83;
  INST_SYNG_REG_WRITE = $85;

  ERR_INVALID_DEVID   = $8000;
  ERR_INVALID_ID      = $4000;
  ERR_DIFF_ID         = $2000;
  ERR_ILLEGAL_SIZE    = $1000;
  ERR_INVALID_PARAM   = $0800;
  ERR_COMM            = $0400;
  ERR_CHECKSUM        = $0200;
  ERR_TIMEOUT         = $0100;
  ERR_DX_INST         = $0040;
  ERR_DX_OVERLOAD     = $0020;
  ERR_DX_CHECKSUM     = $0010;
  ERR_DX_RANGE        = $0008;
  ERR_DX_OVERHEAT     = $0004;
  ERR_DX_ANGLE        = $0002;
  ERR_DX_OVERVOLTAGE  = $0001;
  ERR_NON             = $0000;
  FATAL_ERR           = (ERR_INVALID_DEVID or ERR_INVALID_ID or ERR_DIFF_ID or ERR_ILLEGAL_SIZE or ERR_INVALID_PARAM or ERR_COMM or ERR_CHECKSUM or ERR_TIMEOUT or ERR_DX_INST or ERR_DX_CHECKSUM);

var
  DX_OpenPort       :TDX_OpenPort;
  DX_ClosePort      :TDX_ClosePort;
  DX_SetBaudrate    :TDX_SetBaudrate;
  DX_SetTimeOutOffset:TDX_SetTimeOutOffset;
  DX_Active         :TDX_Active;

  DX_TxPacket       :TDX_TxPacket;
  DX_RxPacket       :TDX_RxPacket;

  DX_ReadByteData   :TDX_ReadByteData;
  DX_WriteByteData  :TDX_WriteByteData;
  DX_ReadWordData   :TDX_ReadWordData;
  DX_WriteWordData  :TDX_WriteWordData;

  DX_ReadBlockData  :TDX_ReadBlockData;
  DX_WriteBlockData :TDX_WriteBlockData;

  DX_Ping           :TDX_Ping;
  DX_Ping2          :TDX_Ping2;
  DX_ReadSyncData   :TDX_ReadSyncData;
  DX_WriteSyncData  :TDX_WriteSyncData;
  DX_Reset          :TDX_Reset;

implementation

var
  DLLHandle:THANDLE;

function conv_s11(v:pword):integer;
begin
  if v^ and $400 <> 0 then result := -(v^ and $3ff) else result := (v^ and $3ff);
end;

function conv_sig(v:pword):integer;
begin
  result := smallint(v^);
end;

function conv_wd(v:pword):integer;
begin
  result := word(v^);
end;

function DXLIB_Load:boolean;
var
  dn, fn:string;
begin
{$IFDEF WIN64}
  DLLHandle := LoadLibrary('dxlib_x64.dll');
{$ELSE}
  DLLHandle := LoadLibrary('dxlib_x32.dll');
{$ENDIF}
  if DLLHandle <> 0 then
  begin
    fn :='DX_OpenPort';
    @DX_OpenPort := GetProcAddress(DLLHandle, PChar(fn));
    fn :='DX_ClosePort';
    @DX_ClosePort := GetProcAddress(DLLHandle, PChar(fn));

    fn :='DX_SetBaudrate';
    @DX_SetBaudrate := GetProcAddress(DLLHandle, PChar(fn));
    fn :='DX_SetTimeOutOffset';
    @DX_SetTimeOutOffset := GetProcAddress(DLLHandle, PChar(fn));
    fn :='DX_Active';
    @DX_Active := GetProcAddress(DLLHandle, PChar(fn));

    fn :='DX_TxPacket';
    @DX_TxPacket := GetProcAddress(DLLHandle, PChar(fn));
    fn :='DX_RxPacket';
    @DX_RxPacket := GetProcAddress(DLLHandle, PChar(fn));

    fn :='DX_ReadByteData';
    @DX_ReadByteData := GetProcAddress(DLLHandle, PChar(fn));
    fn :='DX_WriteByteData';
    @DX_WriteByteData := GetProcAddress(DLLHandle, PChar(fn));

    fn :='DX_ReadWordData';
    @DX_ReadWordData := GetProcAddress(DLLHandle, PChar(fn));
    fn :='DX_WriteWordData';
    @DX_WriteWordData := GetProcAddress(DLLHandle, PChar(fn));

    fn :='DX_ReadBlockData';
    @DX_ReadBlockData := GetProcAddress(DLLHandle, PChar(fn));
    fn :='DX_WriteBlockData';
    @DX_WriteBlockData := GetProcAddress(DLLHandle, PChar(fn));

    fn :='DX_Ping';
    @DX_Ping := GetProcAddress(DLLHandle, PChar(fn));
    fn :='DX_Ping2';
    @DX_Ping2 := GetProcAddress(DLLHandle, PChar(fn));

    fn :='DX_ReadSyncData';
    @DX_ReadSyncData := GetProcAddress(DLLHandle, PChar(fn));
    fn :='DX_WriteSyncData';
    @DX_WriteSyncData := GetProcAddress(DLLHandle, PChar(fn));

    fn :='DX_Reset';
    @DX_Reset := GetProcAddress(DLLHandle, PChar(fn));
  end;
  result :=
    (DLLHandle <> 0)
    and (@DX_OpenPort <> nil)
    and (@DX_ClosePort <> nil)
    and (@DX_SetBaudrate <> nil)
    and (@DX_SetTimeOutOffset <> nil)
    and (@DX_Active <> nil)
    and (@DX_TxPacket <> nil)
    and (@DX_RxPacket <> nil)
    and (@DX_ReadByteData <> nil)
    and (@DX_WriteByteData <> nil)
    and (@DX_ReadWordData <> nil)
    and (@DX_WriteWordData <> nil)
    and (@DX_ReadBlockData <> nil)
    and (@DX_WriteBlockData <> nil)
    and (@DX_Ping <> nil)
//    and (@DX_Ping2 <> nil)
//    and (@DX_Reset <> nil)
    and (@DX_ReadSyncData <> nil)
    and (@DX_WriteSyncData <> nil);
end;

procedure DXLIB_Unload;
begin
 if DXLIB_Active then FreeLibrary(DLLHandle);
end;

function DXLIB_Active:boolean;
begin
  result := DLLHandle <> 0;
end;

begin
  DLLHandle := 0;
end.
