@ECHO OFF
rem Nnecessary ext. tools (lib.exe mspdb100.dll msvcr100.dll)
SET ORGPATH=%PATH%

if "%CommonProgramFiles(x86)%"=="" (goto X32) else (goto X64)

:X32
FOR /F "usebackq" %%t IN (`83 "%ProgramFiles%\BestTech\GCC Developer Lite\GCC\"`) DO SET GCCBIN=%%t
GOTO INPUT

:X64
FOR /F "usebackq" %%t IN (`83 "%ProgramFiles(x86)%\BestTech\GCC Developer Lite\GCC\"`) DO SET GCCBIN=%%t
GOTO INPUT

:INPUT
if not exist %GCCBIN% goto err

echo #### 32bit ####
SET PATH=%GCCBIN%x86\bin;%ORGPATH%
gcc -shared -static-libgcc -static-libstdc++ -o dxlib_x32.dll dxlib.cpp -O3 -Wall -Wno-main -Wno-sign-compare -Wshadow -Wcast-align -Wpointer-arith -Wswitch -Wredundant-decls -Wreturn-type -Wshadow -Wunused -Wl,--add-stdcall-alias,--output-def,dxlib_x32.def,--out-implib,libdxlib_x32.a
if not exist dxlib_x32.dll goto err
if not exist lib.exe goto err
lib /DEF:dxlib_x32.def /MACHINE:X86 /out:dxlib_x32.lib

echo #### 64bit ####
SET PATH=%GCCBIN%x64\bin;%ORGPATH%
gcc -shared -static-libgcc -static-libstdc++ -o dxlib_x64.dll dxlib.cpp -O3 -Wall -Wno-main -Wno-sign-compare -Wshadow -Wcast-align -Wpointer-arith -Wswitch -Wredundant-decls -Wreturn-type -Wshadow -Wunused -Wl,--add-stdcall-alias,--output-def,dxlib_x64.def,--out-implib,libdxlib_x64.a
if not exist dxlib_x64.dll goto err
if not exist lib.exe goto err
lib /DEF:dxlib_x64.def /MACHINE:X64 /out:dxlib_x64.lib
goto ok

rem #### linuxt ####
rem gcc -c -O3 dxlib.cpp -o dxlib.o
rem gcc -fPIC -shared -O3 dxlib.cpp -o dxlib.so

:err
echo ---------------------------
echo !! create lib error !!
echo ---------------------------
goto fin

:ok
echo ---------------------------
echo !! create lib success !!
echo ---------------------------
goto fin

:fin
pause
