/*
  SYNCCXgNVŕID̓AhXɑ΂Čʂ̒l̓ǂݏ

  ^[Qbg:X
*/

#include  <stdio.h>
#include  <conio.h>

#include  "dx2lib.h"
#include  "dx2memmap.h"

// }N`
#define _COMPORT  (5)       // ftHg|[gԍ
#define _BAUDRATE (57600)   // ftHg{[[g[bps]
#define _TARGETID (1)       // ftHgΏID

#define MAXPOS    (4095)
#define MINPOS    (0)
#define DIFFPOS   (2)

#define AXISNUM   (2)   // ΏۂƂȂ鎲(ID=1n܂2,3,4...ƘAĂ̂Ƃ

//------------------------------------------------
// sɃ|[gԍE{[[gEIDI
//------------------------------------------------
bool InputNum (int32_t *num) {
  char buf[100];
  fgets(buf, sizeof(buf), stdin);
  rewind(stdin);
  return (strlen(buf) && sscanf(buf, "%d", num) == 1);
}

bool EditComAndBaudAndTarget (char *comport, uint32_t *comn, uint32_t *baud, uint8_t *id) {
  bool result = true;

  int32_t n;

  printf ("Input comport num (default %d) = ", _COMPORT);
  if (!InputNum (&n)) { n = _COMPORT; result = false; }
  if (n >= 1 && n <= 255) *comn = n; else *comn = _COMPORT;
  sprintf(comport, "\\\\.\\COM%d", *comn);

  printf ("Input baudrate (default %dbps) = ", _BAUDRATE);
  if (!InputNum (&n)) { n = _BAUDRATE; result = false; }
  if (n >= 9600 && n <= 3000000) *baud = n; else *baud = _BAUDRATE;

  printf ("Input target id (default %d) = ", _TARGETID);
  if (!InputNum (&n)) { n = _TARGETID; result = false; }
  if (n >= 1 && n < 0xfd) *id = n; else *id = _TARGETID;

  return result;
}

TDXL_DevType CheckModelInfo (TDeviceID dev, uint8_t id) {
  uint16_t modelno;
  if (DX2_ReadWordData (dev, id, 0, &modelno, NULL)) {
    switch (modelno) {
      case 0x015E:  //XL-320
        return devtXL320;
      case 0x001E:  //MX-28(2.0)
      case 0x0137:  //MX-64(2.0)
      case 0x0141:  //MX-106(2.0)
      case 0x0424:  //XL430-W250
      case 0x0406:  //XM430-W210
      case 0x03F2:  //XH430-W210
      case 0x041A:  //XH430-V210
      case 0x03FC:  //XM430-W350
      case 0x03E8:  //XH430-W350
      case 0x0410:  //XH430-V350
      case 0x046A:  //XM540-W150
      case 0x0456:  //XH540-W150
      case 0x047E:  //XH540-V150
      case 0x0460:  //XM540-W270
      case 0x044C:  //XH540-W270
      case 0x0474:  //XH540-V270
        return devtX;
      case 0xD308:  //H54-200-S500-R
      case 0xD208:  //H54-100-S500-R
      case 0xC800:  //H42-20-S300-R
      case 0xB510:  //M54-60-S250-R
      case 0xB410:  //M54-40-S250-R
      case 0xA918:  //M42-10-S260-R
      case 0x9520:  //L54-50-S290-R
      case 0x9508:  //L54-50-S500-R
      case 0x9428:  //L54-30-S400-R
      case 0x9408:  //L54-30-S500-R
      case 0x8900:  //L42-10-S300-R
        return devtPRO;
      case 0xD309:  //H54-200-S500-RA
      case 0xD209:  //H54-100-S500-RA
      case 0xC801:  //H42-20-S300-RA
      case 0xB511:  //M54-60-S250-RA
      case 0xB411:  //M54-40-S250-RA
      case 0xA919:  //M42-10-S260-RA
      case 0x07E4:  //H54P-200-S500-R
      case 0x07DA:  //H54P-100-S500-R
      case 0x07D0:  //H42P-020-S300-R
        return devtPROP;
      // ̑
      default:
        return devtNONE;
    }
  }
  return devtNONE;
}

//------------------------------------------------
// C
//------------------------------------------------
void main (void) {
  char        comname[20];
  uint32_t    comnum, baud;
  uint8_t     id;

  uint32_t    num;
  int32_t     diff[AXISNUM];
  TDeviceID   dev;
  TErrorCode  err;

  // goal positionWriteSyncDataŏލۂ̃p[^\ (1oCgACgK{)
  struct {
    uint16_t  addr;     // AhX
    uint16_t  length;   // f[^
    struct {
      uint8_t id;       // id
      int32_t gpos;     // f[^
    } __attribute__ ((gcc_struct, __packed__)) axis[AXISNUM];
  } __attribute__ ((gcc_struct, __packed__)) sw_param = {
    ADDRESS_X_GOAL_POSITION,
    sizeof (int32_t),
  };

  // present positionReadSyncDataœǂݏoۂ̍\ (1oCgACgK{)
  TSyncReadParam sr_param = {
    ADDRESS_X_PRESENT_POSITION,
    sizeof (int32_t),
  };
  // ReadSyncDataœǂݏoꂽf[^̍\ (1oCgACgK{)
  struct {
    uint8_t     id;     // id
    TErrorCode  err;    // Xe[^X
    int32_t     ppos;   // f[^
  } __attribute__ ((gcc_struct, __packed__)) sr_data[AXISNUM];

  for (int i = 0; i < AXISNUM; i++) {
    diff[i] = DIFFPOS;
    sw_param.axis[i].id = i + 1;
    sr_param.ids[i] = i + 1;
  }

  // ftHg̐ݒ肩珉ύX
  EditComAndBaudAndTarget (comname, &comnum, &baud, &id);

  // |[gI[v
  if ((dev = DX2_OpenPort (comname, baud))) {
    printf ("Open success\n");

    // SXV[Ył鎖mF
    bool pass = true;
    for (int i = 0; i < AXISNUM; i++) pass = pass && (CheckModelInfo (dev, sr_data[i].id) == devtX);

    if (pass) {
      num = AXISNUM;
      // ě݈ʒuǂݏolƂ
      if (DX2_ReadSyncData (dev, &sr_param, &num, (uint8_t *)&sr_data, &err)) {
        printf ("present pos = ");
        for (int i = 0; i < AXISNUM; i++) {
          sw_param.axis[i].gpos = sr_data[i].ppos;
          printf ("[%d]%4d%s", sr_data[i].id, sr_data[i].ppos, i == AXISNUM - 1 ? "\n\n" : " ");
        }

        // SgNCl[u
        DX2_WriteByteData (dev, BROADCASTING_ID, ADDRESS_X_TORQUE_ENABLE, 1, &err);

        // L[ƃ[v𔲂
        while (!kbhit() && DX2_Active (dev)) {
          // ^邽߂̎Z
          for (int i = 0; i < AXISNUM; i++) {
            sw_param.axis[i].gpos += diff[i];
            if (sw_param.axis[i].gpos >= MAXPOS) {
              sw_param.axis[i].gpos = MAXPOS;
              diff[i] *= -1;
            } else if (sw_param.axis[i].gpos <= MINPOS) {
              sw_param.axis[i].gpos = MINPOS;
              diff[i] *= -1;
            }
            printf ("[%d]%4d%s", sw_param.axis[i].id, sw_param.axis[i].gpos, i == AXISNUM - 1 ? "\r" : " ");
          }
          // ڕWpxw
          DX2_WriteSyncData (dev, (uint8_t *)&sw_param, sizeof (sw_param), &err);

          // 1~b҂
          Sleep (1);
        }

        // SgNfBXG[u
        DX2_WriteByteData (dev, BROADCASTING_ID, ADDRESS_X_TORQUE_ENABLE, 0, &err);
      } else printf ("ReadSync Error [%04X]\n", err);
    }

    // |[gN[Y
    DX2_ClosePort (dev);
  } else printf ("Open error\n");

  printf ("\nFin");
}
