/*
  BYTẼACeւ̃ANZX

  ^[Qbg:PRO
*/

#include  <stdio.h>
#include  <conio.h>
#include  "dx2lib.h"
// foCX̃ACeAhẌꕔ錾
#include  "dx2memmap.h"

// }N`
#define _COMPORT  (5)       // ftHg|[gԍ
#define _BAUDRATE (57600)   // ftHg{[[g[bps]
#define _TARGETID (2)       // ftHgΏID

//------------------------------------------------
// sɃ|[gԍE{[[gEIDI
//------------------------------------------------
bool InputNum (int32_t *num) {
  char buf[100];
  fgets(buf, sizeof(buf), stdin);
  rewind(stdin);
  return (strlen(buf) && sscanf(buf, "%d", num) == 1);
}

bool EditComAndBaudAndTarget (char *comport, uint32_t *comn, uint32_t *baud, uint8_t *id) {
  bool result = true;

  int32_t n;

  printf ("Input comport num (default %d) = ", _COMPORT);
  if (!InputNum (&n)) { n = _COMPORT; result = false; }
  if (n >= 1 && n <= 255) *comn = n; else *comn = _COMPORT;
  sprintf(comport, "\\\\.\\COM%d", *comn);

  printf ("Input baudrate (default %dbps) = ", _BAUDRATE);
  if (!InputNum (&n)) { n = _BAUDRATE; result = false; }
  if (n >= 9600 && n <= 3000000) *baud = n; else *baud = _BAUDRATE;

  printf ("Input target id (default %d) = ", _TARGETID);
  if (!InputNum (&n)) { n = _TARGETID; result = false; }
  if (n >= 1 && n < 0xfd) *id = n; else *id = _TARGETID;

  return result;
}

TDXL_DevType CheckModelInfo (TDeviceID dev, uint8_t id) {
  uint16_t modelno;
  if (DX2_ReadWordData (dev, id, 0, &modelno, NULL)) {
    switch (modelno) {
      case 0x015E:  //XL-320
        return devtXL320;
      case 0x001E:  //MX-28(2.0)
      case 0x0137:  //MX-64(2.0)
      case 0x0141:  //MX-106(2.0)
      case 0x0424:  //XL430-W250
      case 0x0406:  //XM430-W210
      case 0x03F2:  //XH430-W210
      case 0x041A:  //XH430-V210
      case 0x03FC:  //XM430-W350
      case 0x03E8:  //XH430-W350
      case 0x0410:  //XH430-V350
      case 0x046A:  //XM540-W150
      case 0x0456:  //XH540-W150
      case 0x047E:  //XH540-V150
      case 0x0460:  //XM540-W270
      case 0x044C:  //XH540-W270
      case 0x0474:  //XH540-V270
        return devtX;
      case 0xD308:  //H54-200-S500-R
      case 0xD208:  //H54-100-S500-R
      case 0xC800:  //H42-20-S300-R
      case 0xB510:  //M54-60-S250-R
      case 0xB410:  //M54-40-S250-R
      case 0xA918:  //M42-10-S260-R
      case 0x9520:  //L54-50-S290-R
      case 0x9508:  //L54-50-S500-R
      case 0x9428:  //L54-30-S400-R
      case 0x9408:  //L54-30-S500-R
      case 0x8900:  //L42-10-S300-R
        return devtPRO;
      case 0xD309:  //H54-200-S500-RA
      case 0xD209:  //H54-100-S500-RA
      case 0xC801:  //H42-20-S300-RA
      case 0xB511:  //M54-60-S250-RA
      case 0xB411:  //M54-40-S250-RA
      case 0xA919:  //M42-10-S260-RA
      case 0x07E4:  //H54P-200-S500-R
      case 0x07DA:  //H54P-100-S500-R
      case 0x07D0:  //H42P-020-S300-R
        return devtPROP;
      // ̑
      default:
        return devtNONE;
    }
  }
  return devtNONE;
}

//------------------------------------------------
// C
//------------------------------------------------
void main (void) {
  uint8_t     led;
  TDeviceID   dev;
  TErrorCode  err;

  char comname[20];
  uint32_t comnum, baud;
  uint8_t id;

  // ftHg̐ݒ肩珉ύX
  EditComAndBaudAndTarget (comname, &comnum, &baud, &id);
  printf("\nCOM=%s, Baudrate=%d, id=%d\n", comname, baud, id);

  // |[gI[v
  if ((dev = DX2_OpenPort (comname, baud))) {
    printf ("Open success\n");

    uint16_t addr_led;
    // PINGŎwID݂̑mF(f܂ł͔fĂȂ̂Œ)
    switch (CheckModelInfo (dev, id)) {
      case devtXL320: addr_led = 25; break;
      case devtX: addr_led = ADDRESS_X_LED_RED; break;
      case devtPRO: addr_led = ADDRESS_PRO_LED_RED; break;
      case devtPROP: addr_led = ADDRESS_PROP_LED_RED; break;
      default: addr_led = 0; break;
    }
    if (addr_led != 0) {
      for (int i = 0; i < 10; i++) {
        // LED̏Ԃǂݏo
        if (DX2_ReadByteData (dev, id, addr_led, &led, &err))
          printf ("Read ok led=%d\n", led);
        else
          printf ("Read ng [$%04X]\n", err);

        // ǂݏoLED̒l𔽓]
        if (led == 0) led = 255;
        else led = 0;

        // LED֒l
        if (DX2_WriteByteData (dev, id, addr_led, led, &err))
          printf ("Write ok led=%d\n", led);
        else
          printf ("Write ng [$%04X]\n", err);

        // 0.5b҂
        Sleep (500);
      }
    } else printf ("Not supported device ID=%d\n", id);

    // |[gN[Y
    DX2_ClosePort (dev);
  } else
    printf ("Open error\n");

  printf ("Fin\n");
  getchar();
}
