/*
  DXL APIg
   ւ̊pxw
*/

#include <stdio.h>
#include <conio.h>
#include <process.h>
#include "dx2lib.h"

#define COMPORT     "\\\\.\\COM4"  // |[gԍ
#define BAUDRATE    (57600)         // {[[g[bps]

#ifndef _WIN32
#include <unistd.h>
#define Sleep(w)  usleep(w*1000)
#endif

//-----------------------------------------------------------
// \
//-----------------------------------------------------------
// Xbh`Bp\
typedef struct {
  TDeviceID dev;      // foCXID
  const uint8_t *ids; // ID̔z
  int num;            // ID
} TMonInfo;

//-----------------------------------------------------------
// O[oϐ
//-----------------------------------------------------------
bool term = FALSE;  // XbhItO

//===========================================================
// ̌݊pxEpxEG[j^Xbh
//===========================================================
unsigned __stdcall monthread (void *pdev) {
  TMonInfo *info = (TMonInfo *)pdev;
  double  pangle[info->num], pvelo[info->num], pcur[info->num];
  for (int i = 0; i < info->num; i++) pangle[i] = pvelo[i] = pcur[i] = 0.0;
  while (!term) {
    // ݈ʒu擾
    DXL_GetPresentAngles (info->dev, info->ids, pangle, info->num);
    // ݊px擾
    DXL_GetPresentVelocities (info->dev, info->ids, pvelo, info->num);
    // ݓd擾
    DXL_GetPresentCurrents(info->dev, info->ids, pcur, info->num);
    for (int i = 0; i < info->num; i++)
      printf ("(%d:$%04X %4.0f%6.1f)", info->ids[i], DXL_GetErrorCode (info->dev, info->ids[i]), pangle[i], pvelo[i]);
    printf("\r");
    Sleep (10);
  }
  _endthreadex (0);
  return 0;
}

//===========================================================
// C
//===========================================================
void main (void) {
  TMonInfo info;
  HANDLE th;

  // oDynamixelIDꗗ
  uint8_t ids[253];
  // oDynamixel
  int num = 0;

  TDeviceID dev = DX2_OpenPort (COMPORT, BAUDRATE);
  if (dev != 0) {
    printf ("Open success\n");

    // ڑꂽSfoCẌꗗ\
    printf ("scanning devices...");
    num = DXL_ScanDevices (dev, ids);
    printf (" %d device detected.\n", num);
    DXL_PrintDevicesList ((void *)&printf);

    // j^XbhJn
    info.dev = dev;
    info.ids = ids;
    info.num = num;
    th = (HANDLE)_beginthreadex (NULL, 0, &monthread, (void *)&info, 0, NULL);

    // xwߗpϐ
    double velos[num];
    // Velocity[hɐݒ
    if (DXL_SetOperatingModesEquival (dev, ids, num, 1)) {
      // Jn
      DXL_SetTorqueEnablesEquival (dev, ids, num, true);

      for (int i = 0; i < num; i++) velos[i] = 30;  // 30deg/s
      DXL_SetGoalVelocities (dev, ids, velos, num);
      Sleep (2000);
      for (int i = 0; i < num; i++) velos[i] = 50;  // 50deg/s
      DXL_SetGoalVelocities (dev, ids, velos, num);
      Sleep (2000);
      for (int i = 0; i < num; i++) velos[i] = 90;  // 90deg/s
      DXL_SetGoalVelocities (dev, ids, velos, num);
      Sleep (2000);
      for (int i = 0; i < num; i++) velos[i] = -90; // -90deg/s
      DXL_SetGoalVelocities (dev, ids, velos, num);
      Sleep (2000);
      for (int i = 0; i < num; i++) velos[i] = -50; // -50deg/s
      DXL_SetGoalVelocities (dev, ids, velos, num);
      Sleep (2000);
      for (int i = 0; i < num; i++) velos[i] = -30; // -30deg/s
      DXL_SetGoalVelocities (dev, ids, velos, num);
      Sleep (2000);
      for (int i = 0; i < num; i++) velos[i] = 0;   // 0deg/s
      DXL_SetGoalVelocities (dev, ids, velos, num);
      Sleep (500);

      // ~
      DXL_SetTorqueEnablesEquival (dev, ids, num, false);
    }
    // j^XbhI
    term = TRUE;
    WaitForSingleObject (th, 2000);
    CloseHandle (th);

    DX2_ClosePort (dev);
  }
  printf("\n");
}
