/*
  DXL APIg
   pxw
*/

#include <stdio.h>
#include "dx2lib.h"

#define COMPORT     "\\\\.\\COM4"   // |[gԍ
#define BAUDRATE    (57600)         // {[[g[bps]
#define TARGETID    (1)             // ΏID

//===========================================================
// C
//===========================================================
void main (void) {
  TDeviceID dev = DX2_OpenPort (COMPORT, BAUDRATE);

  if (dev != 0) {
    printf ("Open success\n");

    // wID̃foCX擾
    // fNo.DynamixelƈvȂƈȌ@\Ȃ
    printf ("[id:%d] Model Name=%s\n", TARGETID, DXL_GetModelInfo (dev, TARGETID)->name);

    // Wheel[hɐݒ
    if (DXL_SetOperatingMode (dev, TARGETID, 1)) {
      // LED_
      DXL_SetLED (dev, TARGETID, true);
      // gNCl[u
      DXL_SetTorqueEnable (dev, TARGETID, true);

      DXL_SetGoalVelocity (dev, TARGETID, 30.0);   // 30deg/s
      Sleep (5000);
      DXL_SetGoalVelocity (dev, TARGETID, -30.0);  // -30deg/s
      Sleep (5000);
      DXL_SetGoalVelocity (dev, TARGETID, 0.0);    // 0deg/s
      Sleep (1000);

      // gNfBXG[u
      DXL_SetTorqueEnable (dev, TARGETID, false);
      // LED
      DXL_SetLED (dev, TARGETID, false);
    } else {
      printf ("SetOPmode error\n");
    }
    DX2_ClosePort (dev);
  } else {
    printf ("Open error\n");
  }
}
