/*
  I/F̓gp

  ^[Qbg:X
*/

#include  <stdio.h>
#include  <process.h>
#include  <conio.h>
#include  "dx2lib.h"
#include  "dx2memmap.h"

#define COMPORT1  "\\\\.\\COM4"
#define COMPORT2  "\\\\.\\COM5"
#define BAUDRATE  (57600)
#define TARGETID1 (1)
#define TARGETID2 (2)

BOOL terminate = FALSE;

BOOL DxGetPosition (TDeviceID dvid, UCHAR id, int32_t *pos, TErrorCode *err) {
  return DX2_ReadLongData (dvid, id, ADDRESS_X_PRESENT_POSITION, (uint32_t *)pos, err);
}

BOOL DxSetPosition (TDeviceID dvid, UCHAR id, int32_t pos, TErrorCode *err) {
  return DX2_WriteLongData (dvid, id, ADDRESS_X_GOAL_POSITION, (uint32_t)pos, err);
}

unsigned __stdcall thread (void *dum) {
  TDeviceID   dev;
  TErrorCode  err;

  if ((dev = DX2_OpenPort (COMPORT2, BAUDRATE))) {
    printf ("Open %s success\n", COMPORT2);
  } else {
    printf ("Open %s error\n", COMPORT2);
  }

  if (DX2_Active (dev)) DX2_WriteByteData (dev, TARGETID2, ADDRESS_X_TORQUE_ENABLE, 1, &err);

  int32_t pos = 2047, ppos;
  int     f = 5;
  while (!terminate) {
    if (DX2_Active (dev)) {
      pos += f;
      if (pos >= 4095) {
        pos = 4095;
        f *= -1;
      } else if (pos <= 0) {
        pos = 0;
        f *= -1;
      }

      if (!DxSetPosition (dev, TARGETID2, pos, &err))
        printf ("\nSetPos (%s, %d) error [%04X]", COMPORT2, TARGETID2, err);
      if (DxGetPosition (dev, TARGETID2, &ppos, &err))
        printf ("\nGetPos (%s, %d) = %d", COMPORT2, TARGETID2, ppos);
      else
        printf ("\nGetPos (%s, %d) error [%04X]", COMPORT2, TARGETID2, err);
    }
    Sleep (10);
  }
  if (DX2_Active (dev)) {
    DX2_WriteByteData (dev, TARGETID2, ADDRESS_X_TORQUE_ENABLE, 0, &err);
    DX2_ClosePort (dev);
  }

  _endthreadex (0);
  return 0;
}

void main (void) {
  TDeviceID   dev;
  TErrorCode  err;
  HANDLE      mythread;

  // COMPORT2̏ʃXbh
  if ((mythread = (HANDLE)_beginthreadex (NULL, 0, &thread, 0, 0, NULL)) == INVALID_HANDLE_VALUE) {
    printf ("beginthread error\n");
  }

  // COMPORT1̏main
  if ((dev = DX2_OpenPort (COMPORT1, BAUDRATE))) {
    printf ("Open %s success\n", COMPORT1);
  } else {
    printf ("Open %s error\n", COMPORT1);
  }

  if (DX2_Active (dev)) DX2_WriteByteData (dev, TARGETID1, ADDRESS_X_TORQUE_ENABLE, 1, &err);

  int32_t pos = 2047, ppos;
  int     f = 5;
  while (!kbhit()) {
    if (DX2_Active (dev)) {
      pos += f;
      if (pos >= 4095) {
        pos = 4095;
        f *= -1;
      } else if (pos <= 0) {
        pos = 0;
        f *= -1;
      }

      if (!DxSetPosition (dev, TARGETID1, pos, &err))
        printf ("\nSetPos (%s, %d) error [%04X]", COMPORT1, TARGETID1, err);
      if (DxGetPosition (dev, TARGETID1, &ppos, &err))
        printf ("\nGetPos (%s, %d) = %d", COMPORT1, TARGETID1, ppos);
      else
        printf ("\nGetPos (%s, %d) error [%04X]", COMPORT1, TARGETID1, err);
    }
    Sleep (10);
  }

  if (DX2_Active (dev)) {
    DX2_WriteByteData (dev, TARGETID1, ADDRESS_X_TORQUE_ENABLE, 0, &err);
    DX2_ClosePort (dev);
  }

  if (mythread != INVALID_HANDLE_VALUE) {
    terminate = TRUE;
    WaitForSingleObject (mythread, 1000);
  }

  printf ("Fin\n");
}
