/*
  DLLĂЂƂ܂ȂȂ

  ^[Qbg:PRO
*/

#include  <stdio.h>
#include  <conio.h>

#define _DYNAMICLOAD  // dx2lib.hCN[hOɐ錾
#include  "dx2lib.h"
#include  "dx2memmap.h"

// }N`
#define COMPORT   "\\\\.\\COM10" // |[gԍ
#define BAUDRATE  (57000)       // {[[g[bps]
#define TARGETID  (1)           // ΏۂƂȂID

TDXL_DevType CheckModelInfo (TDeviceID dev, uint8_t id) {
  uint16_t modelno;
  if (DX2_ReadWordData (dev, id, 0, &modelno, NULL)) {
    switch (modelno) {
      case 0x015E:  //XL-320
        return devtXL320;
      case 0x001E:  //MX-28(2.0)
      case 0x0137:  //MX-64(2.0)
      case 0x0141:  //MX-106(2.0)
      case 0x0424:  //XL430-W250
      case 0x0406:  //XM430-W210
      case 0x03F2:  //XH430-W210
      case 0x041A:  //XH430-V210
      case 0x03FC:  //XM430-W350
      case 0x03E8:  //XH430-W350
      case 0x0410:  //XH430-V350
      case 0x046A:  //XM540-W150
      case 0x0456:  //XH540-W150
      case 0x047E:  //XH540-V150
      case 0x0460:  //XM540-W270
      case 0x044C:  //XH540-W270
      case 0x0474:  //XH540-V270
        return devtX;
      case 0xD308:  //H54-200-S500-R
      case 0xD208:  //H54-100-S500-R
      case 0xC800:  //H42-20-S300-R
      case 0xB510:  //M54-60-S250-R
      case 0xB410:  //M54-40-S250-R
      case 0xA918:  //M42-10-S260-R
      case 0x9520:  //L54-50-S290-R
      case 0x9508:  //L54-50-S500-R
      case 0x9428:  //L54-30-S400-R
      case 0x9408:  //L54-30-S500-R
      case 0x8900:  //L42-10-S300-R
        return devtPRO;
      case 0xD309:  //H54-200-S500-RA
      case 0xD209:  //H54-100-S500-RA
      case 0xC801:  //H42-20-S300-RA
      case 0xB511:  //M54-60-S250-RA
      case 0xB411:  //M54-40-S250-RA
      case 0xA919:  //M42-10-S260-RA
      case 0x07E4:  //H54P-200-S500-R
      case 0x07DA:  //H54P-100-S500-R
      case 0x07D0:  //H42P-020-S300-R
        return devtPROP;
      // ̑
      default:
        return devtNONE;
    }
  }
  return devtNONE;
}

void main (void) {
  int32_t     maxpos, minpos, diffpos, pos;
  TDeviceID   dev;
  TErrorCode  err;

  // DLL[h
  if (LoadDLL()) {

    if ((dev = DX2_OpenPort (COMPORT, BAUDRATE))) {
      printf ("Open success\n");
      if (CheckModelInfo (dev, TARGETID) == devtPRO) {
        if (
          // őpx擾
          DX2_ReadLongData (dev, TARGETID, ADDRESS_PRO_MAX_POSITION_LIMIT, (uint32_t *)&maxpos, &err) &&
          // ŏpx擾
          DX2_ReadLongData (dev, TARGETID, ADDRESS_PRO_MIN_POSITION_LIMIT, (uint32_t *)&minpos, &err) &&
          // ݊px擾
          DX2_ReadLongData (dev, TARGETID, ADDRESS_PRO_PRESENT_POSITION, (uint32_t *)&pos, &err) &&
          // gNCl[u
          DX2_WriteByteData (dev, TARGETID, ADDRESS_PRO_TORQUE_ENABLE, 1, &err)
        ) {
          diffpos = maxpos / 2000;
          printf ("maxpos=%d, minpos=%d, presentpos = %d\n", maxpos, minpos, pos);

          // L[ƃ[v𔲂
          while (!kbhit()) {
            pos += diffpos;
            if (pos >= maxpos) {
              pos = maxpos;
              diffpos *= -1;
            } else if (pos <= minpos) {
              pos = minpos;
              diffpos *= -1;
            }
            // ڕWʒu
            if (DX2_WriteLongData (dev, TARGETID, ADDRESS_PRO_GOAL_POSITION, pos, &err))
              printf ("Sent position = %7d\r", pos);
            else
              printf ("Write error [$%04X]\n", err);
            // 1~b҂
            Sleep (1);
          }
          // gNfBXG[u
          DX2_WriteByteData (dev, TARGETID, ADDRESS_PRO_TORQUE_ENABLE, 0, &err);
          printf ("\n");
        } else printf ("Read error [$%04X]\n", err);
      } else printf ("Not supported device ID=%d\n", TARGETID);

      DX2_ClosePort (dev);
    } else printf ("Open error\n");

    // DLLA[h
    UnloadDLL();
  } else printf ("Fail to load DLL!\n");

  printf ("Fin\n");
  getchar();
}
