/*
  PINGでネットワーク上の対象を検索

  ターゲット:BAUD=1Mの機器
*/

#include <stdio.h>
#include "dx2lib.h"

// マクロ定義
#define COMPORT   "/dev/ttyUSB0"  // ポート番号
#define BAUDRATE  (2000000)       // ボーレート[bps]

void main (void) {
  TDeviceID  dev;
  TErrorCode  err;

  if ((dev = DX2_OpenPort (COMPORT, BAUDRATE))) {
    printf ("Open success\n");

    int i, num = 100;
    TDxAlarmStatus stat[253];
    if (DX2_Ping2 (dev, &num, stat, &err)) {
      for (i = 0; i < num; i++)
        printf ("Found ID=%d %02X\n", stat[i].id, stat[i].Status);
    }
    printf("num=%d\n",num);

    DX2_ClosePort (dev);
  } else {
    printf ("Open error\n");
  }

  printf ("Fin\n");

  getchar ();
}
