/*
  }`Xbh1̃^[Qbgւ̔񓯊ANZX

  ^[Qbg:PRO, X
*/

#include  <stdio.h>
#include  <conio.h>
#include  <process.h>

#include  "dx2lib.h"
#include  "dx2memmap.h"

//#include  "whoareyou.h"

// }N`
#define COMPORT   "\\\\.\\COM10" // |[gԍ
#define BAUDRATE  (57600)       // {[[g[bps]
#define TARGETID  (1)           // ΏۂƂȂID

BOOL    terminate = FALSE;  // XbhItO
int16_t adr_max, adr_min, adr_ppos, adr_pos, adr_ten; // eACẽAhX

TDXL_DevType CheckModelInfo (TDeviceID dev, uint8_t id) {
  uint16_t modelno;
  if (DX2_ReadWordData (dev, id, 0, &modelno, NULL)) {
    switch (modelno) {
      case 0x015E:  //XL-320
        return devtXL320;
      case 0x001E:  //MX-28(2.0)
      case 0x0137:  //MX-64(2.0)
      case 0x0141:  //MX-106(2.0)
      case 0x0424:  //XL430-W250
      case 0x0406:  //XM430-W210
      case 0x03F2:  //XH430-W210
      case 0x041A:  //XH430-V210
      case 0x03FC:  //XM430-W350
      case 0x03E8:  //XH430-W350
      case 0x0410:  //XH430-V350
      case 0x046A:  //XM540-W150
      case 0x0456:  //XH540-W150
      case 0x047E:  //XH540-V150
      case 0x0460:  //XM540-W270
      case 0x044C:  //XH540-W270
      case 0x0474:  //XH540-V270
        return devtX;
      case 0xD308:  //H54-200-S500-R
      case 0xD208:  //H54-100-S500-R
      case 0xC800:  //H42-20-S300-R
      case 0xB510:  //M54-60-S250-R
      case 0xB410:  //M54-40-S250-R
      case 0xA918:  //M42-10-S260-R
      case 0x9520:  //L54-50-S290-R
      case 0x9508:  //L54-50-S500-R
      case 0x9428:  //L54-30-S400-R
      case 0x9408:  //L54-30-S500-R
      case 0x8900:  //L42-10-S300-R
        return devtPRO;
      case 0xD309:  //H54-200-S500-RA
      case 0xD209:  //H54-100-S500-RA
      case 0xC801:  //H42-20-S300-RA
      case 0xB511:  //M54-60-S250-RA
      case 0xB411:  //M54-40-S250-RA
      case 0xA919:  //M42-10-S260-RA
      case 0x07E4:  //H54P-200-S500-R
      case 0x07DA:  //H54P-100-S500-R
      case 0x07D0:  //H42P-020-S300-R
        return devtPROP;
      // ̑
      default:
        return devtNONE;
    }
  }
  return devtNONE;
}

// ݈ʒuǂݏo
BOOL GetPosition (TDeviceID dvid, UCHAR id, int32_t *pos, TErrorCode *err) {
  return DX2_ReadLongData (dvid, id, adr_ppos, (uint32_t *)pos, err);
}

// ڕWʒu
BOOL SetPosition (TDeviceID dvid, UCHAR id, int32_t pos, TErrorCode *err) {
  return DX2_WriteLongData (dvid, id, adr_pos, (uint32_t)pos, err);
}

// Xbh
unsigned __stdcall testThread (void *pdev) {
  TDeviceID   dev = (TDeviceID)pdev;
  TErrorCode  err;
  int p;

  while (!terminate && DX2_Active (dev)) {
    // ݈ʒu̓ǂݎ
    GetPosition (dev, TARGETID, &p, &err) ? printf ("\rPresent Pos=%7d     ", p) : printf ("\rGet Present Pos error [$%04X]", err);

    Sleep (1);
  }

  _endthreadex (0);
  return 0;
}

void main (void) {
  TDeviceID   dev;
  TErrorCode  err;
  int32_t     maxpos, minpos, diffpos, pos;
  HANDLE      mythread;

  SetPriorityClass (GetCurrentProcess(), REALTIME_PRIORITY_CLASS);  // vCIeBグ

  if ((dev = DX2_OpenPort (COMPORT, BAUDRATE))) {
    printf ("Open success\n");

    switch (CheckModelInfo (dev, TARGETID)) {
      case devtX:
        adr_max  = ADDRESS_X_MAX_POSITION_LIMIT;
        adr_min  = ADDRESS_X_MIN_POSITION_LIMIT;
        adr_ppos = ADDRESS_X_PRESENT_POSITION;
        adr_ten  = ADDRESS_X_TORQUE_ENABLE;
        adr_pos  = ADDRESS_X_GOAL_POSITION;
        break;
      case devtPRO:
        adr_max  = ADDRESS_PRO_MAX_POSITION_LIMIT;
        adr_min  = ADDRESS_PRO_MIN_POSITION_LIMIT;
        adr_ppos = ADDRESS_PRO_PRESENT_POSITION;
        adr_ten  = ADDRESS_PRO_TORQUE_ENABLE;
        adr_pos  = ADDRESS_PRO_GOAL_POSITION;
        break;
      case devtPROP:
        adr_max  = ADDRESS_PROP_MAX_POSITION_LIMIT;
        adr_min  = ADDRESS_PROP_MIN_POSITION_LIMIT;
        adr_ppos = ADDRESS_PROP_PRESENT_POSITION;
        adr_ten  = ADDRESS_PROP_TORQUE_ENABLE;
        adr_pos  = ADDRESS_PROP_GOAL_POSITION;
        break;
      // ̑
      default:
        adr_max  = 0;
        adr_min  = 0;
        adr_ppos = 0;
        adr_ten  = 0;
        adr_pos  = 0;
        break;
    }

    if (adr_max != 0) {
      if (
        // őpx擾
        DX2_ReadLongData (dev, TARGETID, adr_max, (uint32_t *)&maxpos, &err) &&
        // ŏpx擾
        DX2_ReadLongData (dev, TARGETID, adr_min, (uint32_t *)&minpos, &err) &&
        // ݊px擾
        DX2_ReadLongData (dev, TARGETID, adr_ppos, (uint32_t *)&pos, &err)
      ) {
        diffpos = (maxpos - minpos) / 2000;
        printf ("maxpos=%d, minpos=%d, presentpos=%d\n", maxpos, minpos, pos);
        // ǂݏopXbh쐬
        if ((mythread = (HANDLE)_beginthreadex (NULL, 0, &testThread, (void *)dev, 0, NULL)) == INVALID_HANDLE_VALUE) {
          printf ("Beginthread error\n");
        } else {
          // gNCl[u
          DX2_WriteByteData (dev, TARGETID, adr_ten, 1, &err);

          // L[ƃ[v𔲂
          while (!kbhit() && DX2_Active (dev)) {
            pos += diffpos;
            if (pos >= maxpos)      {
              pos = maxpos;
              diffpos *= -1;
            } else if (pos <= minpos) {
              pos = minpos;
              diffpos *= -1;
            }
            if (!SetPosition (dev, TARGETID, pos, &err)) printf ("\nSet Goal Position error [$%04X]\n", err);
            Sleep (1);
          }
          // XbhI
          terminate = TRUE;
          WaitForSingleObject (mythread, 2000);
          CloseHandle (mythread);

          // gNfBXG[u
          DX2_WriteByteData (dev, TARGETID, adr_ten, 0, NULL);
        }
      } else printf ("Initalization error\n");
    } else printf ("Not support device\n");

    DX2_ClosePort (dev);
  } else printf ("Open error\n");

  printf ("\nFin");
  getchar();
}
