/*
  DXL APIg
   pxw
*/

#include <stdio.h>
#include "dx2lib.h"

#define COMPORT     "\\\\.\\COM4"   // |[gԍ
#define BAUDRATE    (57600)         // {[[g[bps]
#define TARGETID    (1)             // ΏۂƂȂID

//===========================================================
// C
//===========================================================
void main (void) {
  TDeviceID dev = DX2_OpenPort (COMPORT, BAUDRATE);

  if (dev != 0) {
    printf ("Open success\n");

    // wID̃foCX擾
    // fNo.DynamixelƈvȂƈȌ@\Ȃ
    printf ("[id:%d] Model Name=%s\n", TARGETID, DXL_GetModelInfo (dev, TARGETID)->name);

    // }`^[Joint[hɐݒ
    if (DXL_SetOperatingMode (dev, TARGETID, 4)) {
      // LED_
      DXL_SetLED (dev, TARGETID, true);
      // gNCl[u
      DXL_SetTorqueEnable (dev, TARGETID, true);

      DXL_SetGoalAngle (dev, TARGETID, 720.0);   // 720deg
      Sleep (5000);
      DXL_SetGoalAngle (dev, TARGETID, -720.0);  // -720deg
      Sleep (10000);
      DXL_SetGoalAngle (dev, TARGETID, 0.0);    // 0deg
      Sleep (5000);

      // gNfBXG[u
      DXL_SetTorqueEnable (dev, TARGETID, false);
      // LED
      DXL_SetLED (dev, TARGETID, false);
    } else {
      printf ("SetOPmode error\n");
    }
    DX2_ClosePort (dev);
  } else {
    printf ("Open error\n");
  }
}
