/*----------------------------------------------------------------------*
    smpl8.c
    Tv8 - Version 1.4
    [IIC EEPROMANZX]
    Copyright (C) 2005 BestTechnology CO.,LTD.
 *----------------------------------------------------------------------*/

/*----------------------------------------------------------------------
 yvOTvz
  nCp[^[~i̒ʐM\tgɐڑĎgp܂B

  ȂA}CR{[hʂJP3JP4𔼓cŃV[gĂKv
  ܂B

  ^[~i1̃R}h͂ƁAɉEEPROMւ̏
  ݁EǂݏoEs܂B
  ----------------------------------------------------------------------
 yڍׁz
  eeprom.cłH8/3687FIICoXI/FgpAeXEEPROM̗eʂɉ
  vgRŒʐMTu[`pӂĂ܂B

    E\
      TEEPROM {
        TMemorySize   MemSize;  TCY
                                (ep1k, ep2k, ep4k, ep8k, ep16k, ep32k,
                                 ep64k, ep128k, ep256k, ep512k, ep1M)
        _BYTE         DAddr;    foCXAhX
        _LONG         MAddr;    AhX
      }

    EwAhX1oCg
     int EEPROM_ByteWrite (TEEPROM *, _BYTE);
      1:
      2:ރf[^

    EwAhXCӃoCg
     int EEPROM_BlockWrite (TEEPROM *, _BYTE *, long);
      1:
      2:ރf[^̃|C^
      3:ރf[^̃oCgTCY

    ES
     int EEPROM_EraseAll (TEEPROM *);
      1:
      2:ރf[^
      3:

    EwAhX1oCgǂݏo
     int EEPROM_ByteRead (TEEPROM *, _BYTE *);
      1:
      2:ǂݍރf[^̕ۑ|C^

    EwAhXCӃoCgǂݏo
     int EEPROM_BlockRead (TEEPROM *, _BYTE *, long);
      1:
      2:ǂݍރf[^̕ۑ|C^
      3:ǂݍރf[^̃oCgTCY
  ----------------------------------------------------------------------*/

#include <3687.h>       // H8 Tiny̓I/O`

// ܂ł̋LqƂ̌݊ۂ߂̃}N
#define rs_init     SCI3_INIT
#define rs_rx_buff  SCI3_IN_DATA_CHECK
#define rs_tx_buff  SCI3_OUT_DATA_CHECK
#define rs_rx_purge SCI3_IN_DATA_CLEAR
#define rs_tx_purge SCI3_OUT_DATA_CLEAR
#define rs_putc     SCI3_OUT_DATA
#define rs_puts     SCI3_OUT_STRING
#define rs_putsb    SCI3_OUT_STRINGB
#define rs_getc     SCI3_IN_DATA
#define rs_gets     SCI3_IN_STRING
#define rs_printf   SCI3_PRINTF

 // Mpobt@
char txb[20], rxb[20];

TEEPROM eep = {ep4k, 0, 0}; // gp郁 (4krbgEEPROM, foCXAhX0)

const char test[]="0123456789ABCDEFabcdefghijklmnopqrstuvwxyz!?@+-/*\r";

/*-----------------------------------------------*/
/* C                                        */
/*-----------------------------------------------*/
void main (void)
{
  int   i;
  _BYTE c, d[50];

  // ʐM|[g {[[g57600[bps]
  rs_init (br57600, txb, sizeof(txb), rxb, sizeof(rxb));

  EI;

  rs_puts (
    "\n<SMPL7 start>\n"
    "\nIIC EEPROM TEST PROGRAM\n"
  );

  while (1) {
    rs_puts ("\n>");

    rs_putc (c = rs_getc ());
    switch (c) {
      // 
      case 'w':
      case 'W':
        rs_puts ("\n[WRITE] After inputting the character string which you write, please push the entering key.\n");

        for (eep.MAddr = 0, c = 0; eep.MAddr < (eep.MemSize * 128L) && c != '\r'; eep.MAddr++) {
          rs_putc (c = rs_getc ());
          if (EEPROM_ByteWrite (&eep, c) <= 0) {
            rs_puts ("*WRITE ERROR*\n");
            break;
          }
        }
        break;

      // ubN
      case 'b':
      case 'B':
        rs_puts ("\n[BLOCK WRITE]\n");

        eep.MAddr = 0;
        if (EEPROM_BlockWrite (&eep, (_BYTE *)&test, sizeof(test)) <= 0) rs_puts ("[WRITE ERROR]");
        break;

      // ǂݏo
      case 'r':
      case 'R':
        rs_puts("\n[READ]\n");

        for (eep.MAddr = 0, c = 0; eep.MAddr < (eep.MemSize * 128L) && c != '\r'; eep.MAddr++) {
          if (EEPROM_ByteRead (&eep, (_BYTE *)&c)) rs_putc (c);
          else {
            rs_puts ("*READ ERROR*\n");
            break;
          }
        }
        break;

      // ubNǂݍ
      case 'f':
      case 'F':
        rs_printf ("\n[BLOCK READ] Block size=%d\n", sizeof(d));

        eep.MAddr = 0;
        if (!EEPROM_BlockRead (&eep, (_BYTE *)&d, sizeof (d))) rs_puts ("[READ ERROR]");
        else for (i = 0; i < sizeof (d) && d[i] != '\r'; i++) rs_putc (d[i]);
        break;

      // S
      case 'e':
      case 'E':
        rs_puts("\n[ERASE] In the midst of elimination. \n");
        if (EEPROM_EraseAll (&eep) <= 0) rs_puts ("*ERASE ERROR*");
        break;
      case '?':
        rs_puts(
          "\n COMMAND LIST\n"
          " w : byte write\n"
          " b : block write \n"
          " r : read all data\n"
          " f : block read\n"
          " e : erase all\n"
        );
        break;
      // ̑

      default:
        rs_puts("\n*Command Error*\n");
        break;
    }
  }
}
